function ok=STM32F103_IO_Config(skt,Port,Pin,Mode)
%ok=UDP_ARM_IO_Config(Port,Pin,)
%Configure an ARM STM gpio/pin register
%  skt    : The udp skt
%  Port   : The GPIO port name such as GPIOA or GPIOC
%  Pin    : The io port pin number - 0 to 15
%  Mode   This is CNF:MODE in the datasheet
%     : 0  - Input  - Analogue
%     : 1  - Output - push-pull  - 10Mhz
%     : 2  - Output - push-pull  - 2Mhz
%     : 3  - Output - push-pull  - 50Mhz
%     : 4  - Input  - Floating
%     : 5  - Output - open Drain - 10Mhz
%     : 6  - Output - open Drain - 2Mhz
%     : 7  - Output - open Drain - 50Mhz
%     : 8  - Input  - pull-up/pulldown
%     : 9  - Alternate Function Output - push-pull  - 10Mhz
%     : 10 - Alternate Function Output- push-pull  - 2Mhz
%     : 11 - Alternate Function Output- push-pull  - 50Mhz
%     : 12 - Input - Reserved
%     : 13 - Alternate Function Output- open drain  - 10Mhz
%     : 14 - Alternate Function Output - open drain  - 2Mhz
%     : 15 - Alternate Function Output- open drain  - 50Mhz


%
% e.g. STM32F103_IO_Config(skt,"GPIOA",Pin,0)
% e.g. STM32F103_IO_Config(skt,"GPIOC",[13 14],1)
% Ian Stothers 8-6-2020
%Modified for STM32F103 20/6/2022
% https://www.st.com/resource/en/reference_manual/cd00171190-stm32f101xx-stm32f102xx-stm32f103xx-stm32f105xx-and-stm32f107xx-advanced-arm-based-32-bit-mcus-stmicroelectronics.pdf

%Make sure peripheral clock is on
udp_bit_set(skt,"RCC_APB2ENR",2^(toupper(Port(end))-'A'+2));

%Mode
ok=0;
idx=find(Pin<8);
if (min(size(idx))>0)
  mode_msk= sum(15*(16.^Pin(idx)));
  mode_val= sum(Mode*(16.^Pin(idx)));
  pname=[Port "_CRL"];
  udp_bit_clear(skt,pname,mode_msk);
  udp_bit_set(skt,pname,mode_val);
end
idx=find(Pin>=8);
if (min(size(idx))>0)
  mode_msk= sum(15*(16.^(Pin(idx)-8)));
  mode_val= sum(Mode*(16.^(Pin(idx)-8)));
  pname=[Port "_CRH"];
  udp_bit_clear(skt,pname,mode_msk);
  udp_bit_set(skt,pname,mode_val);
end
  ok=1;
end

 % some day put some parameter checking in?
